<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/"
	xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/"
	xmlns:http="http://schemas.xmlsoap.org/wsdl/http/"
	xmlns:mime="http://schemas.xmlsoap.org/wsdl/mime/">

<xsl:output method="html" indent="yes"/>

<xsl:template match="/">
<html>
	<link rel="stylesheet" href="http://www-server/~mangano/wsdlToHtml.css" /> 
	<head>
		<xsl:comment>WSDL Documentation: Generated by the wsdlToDoc.xslt</xsl:comment>
	</head>

	<body class="text">
		<xsl:apply-templates />
	</body>
</html>
</xsl:template>

<xsl:template match="wsdl:definitions" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword"/>
	<xsl:value-of select="@name" />
	
	<xsl:if test="@targetNamespace">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="' targetNamespace'"/>
		</xsl:call-template>
		<xsl:value-of select="@targetNamespace" />
	</xsl:if>
	
	<xsl:call-template name="openbrace"/>
	<xsl:apply-templates />
	<xsl:call-template name="closebrace"/>
</xsl:template>

<xsl:template match="wsdl:import" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword"/>
	<xsl:value-of select="@namespace"/>
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="' from'"/>
	</xsl:call-template>
	<xsl:element name="a">
		<xsl:attribute name="href"><xsl:value-of select="@location"/></xsl:attribute>
		<xsl:value-of select="@location"/>
	</xsl:element>
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="wsdl:types|wsdl:message|wsdl:portType|wsdl:service|mime:multipartRelated|wsdl:operation[parent::wsdl:binding]|wsdl:input[ancestor::wsdl:binding] | wsdl:output[ancestor::wsdl:binding] | wsdl:fault[ancestor::wsdl:binding]" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword"/>
	<xsl:value-of select="@name"/>
	
	<xsl:call-template name="openbrace"/>
	<xsl:apply-templates />
	<xsl:call-template name="closebrace"/>
</xsl:template>

<xsl:template match="wsdl:part" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword"/>
	<xsl:value-of select="@name" />
	<xsl:if test="@element">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="' element'"/>
		</xsl:call-template>
		<xsl:value-of select="@element"/></xsl:if>
	<xsl:if test="@type">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="' type'"/>
		</xsl:call-template>
		<xsl:value-of select="@type"/>
	</xsl:if>
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="wsdl:operation" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	
	<!-- Check the type of operation and if it is not a request-response display 
		the appropriate keyword. -->
	<xsl:if test="wsdl:input and not(wsdl:output)">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="'oneway'"/>
		</xsl:call-template>
	</xsl:if>
	<xsl:if test="not(wsdl:input) and wsdl:output">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="'notification'"/>
		</xsl:call-template>
	</xsl:if>
	<xsl:if test="wsdl:input[preceding-sibling::wsdl:output]">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="'solicit-response'"/>
		</xsl:call-template>
	</xsl:if>
	
	<!-- The output message -->
	<xsl:value-of select="wsdl:output/@message"/>
	<xsl:text>&#160;</xsl:text>
	
	<!-- The operation name -->
	<xsl:value-of select="@name"/>
	
	<!-- The input message -->
	<a class="punctuation"> ( </a>
	<xsl:value-of select="wsdl:input/@message"/>
	<a class="punctuation"> ) </a>
	
	<!-- The fault messages -->
	<xsl:if test="wsdl:fault">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="' throws'"/>
		</xsl:call-template>
		<xsl:for-each select="wsdl:fault">
			<xsl:value-of select="@message" />
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template match="wsdl:binding" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	
	<xsl:if test="soap:binding">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="'soap-binding'"/>
		</xsl:call-template>
	</xsl:if>
	<xsl:if test="http:binding">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="'http-binding'"/>
		</xsl:call-template>
	</xsl:if>
	
	<xsl:value-of select="@name" />
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="' for portType'"/>
	</xsl:call-template>
	<xsl:value-of select="@type" /> 
	
	<xsl:call-template name="openbrace"/>
	<xsl:apply-templates />
	<xsl:call-template name="closebrace"/>
</xsl:template>

<xsl:template match="wsdl:port" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword"/>
	<xsl:value-of select="@name" />
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="' for binding'"/>
	</xsl:call-template>
	<xsl:value-of select="@binding" /> 
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="' at'"/>
	</xsl:call-template>
	<xsl:value-of select="soap:address/@location | http:address/@location" />
</xsl:template>

<xsl:template match="soap:binding" >
	<xsl:call-template name="attribute">
		<xsl:with-param name="attr" select="@style" />
	</xsl:call-template>

	<xsl:call-template name="attribute">
		<xsl:with-param name="attr" select="@transport" />
	</xsl:call-template>
	<xsl:call-template name="newline"/>
</xsl:template>

<xsl:template match="soap:operation" >
	<xsl:call-template name="attribute">
		<xsl:with-param name="attr" select="@soapAction" />
	</xsl:call-template>

	<xsl:call-template name="attribute">
		<xsl:with-param name="attr" select="@style" />
	</xsl:call-template>

</xsl:template>

<xsl:template match="soap:body | soap:header | soap:fault" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="concat('soap-',local-name(.))"/>
	</xsl:call-template>
	<xsl:value-of select="@message"/>
	
	<xsl:call-template name="openbrace"/>
	
	<xsl:for-each select="@*[not(name(.) = 'message')]">
		<xsl:call-template name="attribute">
			<xsl:with-param name="attr" select="." />
		</xsl:call-template>
	</xsl:for-each>
	<xsl:apply-templates />
	<xsl:call-template name="closebrace"/>
</xsl:template>

<xsl:template match="soap:headerfault" >
	<xsl:call-template name="documentation"/>
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="concat('soap-',local-name(.))"/>
	</xsl:call-template>
	<xsl:value-of select="@name"/>
	
	<xsl:call-template name="openbrace"/>
	
	<xsl:for-each select="@*[not(name(.) = 'name')]">
		<xsl:call-template name="attribute">
			<xsl:with-param name="attr" select="." />
		</xsl:call-template>
	</xsl:for-each>
	<xsl:apply-templates />
	<xsl:call-template name="closebrace"/>
</xsl:template>

<xsl:template match="http:binding" >
	<xsl:call-template name="attribute">
		<xsl:with-param name="attr" select="@verb" />
	</xsl:call-template>
</xsl:template>

<xsl:template match="http:operation" >
	<xsl:call-template name="attribute">
		<xsl:with-param name="attr" select="@location" />
	</xsl:call-template>
</xsl:template>

<xsl:template match="http:urlEncoded | http:urlReplacement" >
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword"/>
</xsl:template>

<xsl:template match="mime:content" >
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="'mime content '"/>
	</xsl:call-template>
	
	<xsl:if test="@part">
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="' for '"/>
	</xsl:call-template>
		<xsl:value-of select="@part" />
	</xsl:if>
	
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="' is '"/>
	</xsl:call-template>
	<xsl:value-of select="@type" />
</xsl:template>

<xsl:template match="mime:content" >
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="'mime content '"/>
	</xsl:call-template>
	
	<xsl:if test="@part">
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="' for '"/>
	</xsl:call-template>
		<xsl:value-of select="@part" />
	</xsl:if>
	
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="' is '"/>
	</xsl:call-template>
	<xsl:value-of select="@type" />
</xsl:template>

<xsl:template match="mime:mimeXml" >
	<xsl:call-template name="newline"/>
	<xsl:call-template name="keyword">
		<xsl:with-param name="word" select="'mime XML for '"/>
	</xsl:call-template>
	<xsl:value-of select="@part" />
	<xsl:if test="@element">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="' element'"/>
		</xsl:call-template>
		<xsl:value-of select="@element"/></xsl:if>
	<xsl:if test="@type">
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="' type'"/>
		</xsl:call-template>
		<xsl:value-of select="@type"/>
	</xsl:if>
	<xsl:apply-templates />
</xsl:template>

<!-- Display documentation nodes as Java style comments -->
<xsl:template name="documentation" >
	<xsl:param name="doc" select="wsdl:documentation" />

	<xsl:if test="$doc" >
		<xsl:for-each select="$doc/parent::node()">
			<xsl:call-template name="newline"/>
		</xsl:for-each>
		<a class="comment">/** <xsl:value-of select="$doc" /> */</a>
	</xsl:if>
</xsl:template>

<xsl:template match="wsdl:documentation" />


<xsl:template match="comment()" >
	<xsl:call-template name="newline"/>
	<a class="comment">&lt;-- <xsl:value-of select="." /> --&gt;</a>
</xsl:template>

<!-- Display attribute as a name value pair with attribute name formatted as a keyword -->
<xsl:template name="attribute">
	<xsl:param name="attr" select="@*[1]" />
	<xsl:param name="word" select="name($attr)" />

	<xsl:if test="$attr">
		<!-- start newline and add indentation -->
		<xsl:call-template name="newline"/>
		
		<xsl:call-template name="keyword">
			<xsl:with-param name="word" select="$word"/>
			<xsl:with-param name="newline" select="false()"/>
		</xsl:call-template>
		<xsl:value-of select="$attr" /> 

	</xsl:if>
</xsl:template>

<!-- Default rule, used for unexpected elements, outputs them as syntax highlighted XML -->
<xsl:template match="*" >
	
	<!-- start newline and add indentation -->
	<xsl:call-template name="newline"/>
	
	<!-- open starting tag -->
	<a class="punctuation">&lt;</a>
	<a class="tag"><xsl:value-of select="name(.)" /> </a>
	
	<!-- Output all the attributes -->
	<xsl:for-each select="@*">
		<a class="attribute"><xsl:text> </xsl:text><xsl:value-of select="name(.)" />  </a>
		<a class="punctuation">=&quot;</a>
		<xsl:value-of select="." />
		<a class="punctuation">&quot;</a>
	</xsl:for-each>

	<xsl:choose>
		<xsl:when test="child::node()">
			<!-- close starting tag -->
			<a class="punctuation">&gt;</a>
	
			<!-- Apply templates for all child elements -->
			<xsl:apply-templates />
	
			<!-- start newline and add indentation for closing tag -->
			<xsl:call-template name="newline"/>
	
			<!-- closing tag -->
			<a class="punctuation">&lt;</a>
			<a class="tag">/<xsl:value-of select="name(.)" /></a>
		</xsl:when>
		<xsl:otherwise>
			<a class="tag">/</a>
		</xsl:otherwise>
	</xsl:choose>
	<a class="punctuation">&gt;</a>
</xsl:template>

<!-- Displays a keyword, getting the default value from the name of the current node -->
<xsl:template name="keyword">
	<xsl:param name="word" select="local-name(.)" />

	<a class="keyword">
	<xsl:value-of select="concat($word,' ')"/>
	</a>
</xsl:template>

<!-- Starts a new line and added the appropriate level of indentation-->
<xsl:template name="newline">
	<br/>
	<xsl:for-each select="ancestor::*">
		<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
	</xsl:for-each>
</xsl:template>

<!-- Adds an open brace on a newline  -->
<xsl:template name="openbrace">
	<xsl:call-template name="newline"/>
	<a class="punctuation">{</a>
</xsl:template>

<!-- Adds a closing brace on a newline  -->
<xsl:template name="closebrace">
	<xsl:call-template name="newline"/>
	<a class="punctuation">}</a>
</xsl:template>


</xsl:stylesheet>
